function hiscale_addrainpatch(timezone)
% adds the hiscale raindates and sample dates as partially transparent
% patches to timeseries

%% Input Checking
if nargin == 0
	timezone = 'utc';
end

hold on;
ylimits = get(gca,'YLim');
ymin = min(ylimits);
ymax = max(ylimits);
patchy = [ymin, ymax, ymax, ymin];

%% Rain times
raintimes_cdt = {...
	[2016,04,26,23,17,00], [2016,04,27,03,30,00];...
	[2016,04,29,12,40,00], [2016,04,29,19,14,00];...
	[2016,05,10,00,47,00], [2016,05,10,01,32,00];...
	[2016,05,13,22,49,00], [2016,05,14,00,31,00];...
	[2016,05,16,06,25,00], [2016,05,16,09,03,00];...
	[2016,05,16,15,17,00], [2016,05,16,16,52,00];...
	[2016,05,17,04,13,00], [2016,05,17,07,02,00]};

% Converting cdt times into utc
raintimes_utc = raintimes_cdt;
for rain_idx = 1:numel(raintimes_cdt)
	raintimes_utc{rain_idx}(4) = raintimes_cdt{rain_idx}(4) + 5;
end

if contains(timezone,'utc')
	raindates = cellfun(@datetime,raintimes_utc);
elseif contains(timezone,'cdt')
	raindates = cellfun(@datetime,raintimes_cdt);
end

% Plotting the patches
for g = 1:size(raindates,1)
	patchx = [raindates(g,1), raindates(g,1), raindates(g,2), raindates(g,2)];
	fill(patchx,patchy,'red','FaceAlpha',0.35,'EdgeAlpha',0);
end

%% Sample times
sampledates_vec_cdt = {...
	[2016,04,26,14,00,00],[2016,04,26,15,30,00];...
	%[2016,04,27,07,55,00],[2016,04,27,17,00,00];...
	%[2016,04,27,22,00,00],[2016,04,28,04,45,00];...
	[2016,04,28,09,45,00],[2016,04,28,14,50,00];...
	[2016,04,28,18,30,00],[2016,04,29,04,30,00];...
	%[2016,04,30,11,30,00],[2016,04,30,18,30,00];...
	[2016,05,01,11,30,00],[2016,05,01,15,30,00];...
	[2016,05,02,09,00,00],[2016,05,02,17,15,00];...
	[2016,05,02,20,00,00],[2016,05,03,06,00,00];...
	[2016,05,05,08,00,00],[2016,05,05,21,00,00];...
	[2016,05,06,12,00,00],[2016,05,06,16,45,00];...
	[2016,05,07,11,00,00],[2016,05,07,15,40,00];...
	[2016,05,10,12,00,00],[2016,05,10,16,45,00];...
	%[2016,05,12,09,00,00],[2016,05,12,14,45,00];...
	%[2016,05,13,11,00,00],[2016,05,13,14,45,00];...
	[2016,05,14,11,00,00],[2016,05,14,15,45,00]};


sampledates_vec_utc = sampledates_vec_cdt;

for sample_idx = 1:numel(sampledates_vec_cdt)
	sampledates_vec_utc{sample_idx}(4) = sampledates_vec_cdt{sample_idx}(4) + 5;
end

if contains(timezone,'utc')
	sampledates = cellfun(@datetime,sampledates_vec_utc);
elseif contains(timezone,'cdt')
	sampledates = cellfun(@datetime,sampledates_vec_cdt);
end



for q = 1:size(sampledates,1)
	patchx = [sampledates(q,1), sampledates(q,1), sampledates(q,2), sampledates(q,2)];
	fill(patchx,patchy,'black','FaceAlpha',0.3,'EdgeAlpha',0);
end




end